exception Not_Implemented
exception Invalid_Action of string

module Map :
  sig
    type t
    type loc = int
    type symbol = Snow | Grass | Forest | Hill | Limbo
	type entry = Blank | Symbol of symbol   (* ʿ ̴ ɺ *)
	
	val size: t -> int
	val get:  int -> t -> entry
	val make: entry list -> t
  end

module Ruletable :
  sig
    type state = string
    type todo = Modify of Map.symbol | Erase | None
    type move = Left | Right | Stay
    type symbol = Map.entry
    type t = (state * symbol * todo * move * state) list
  end

module Supporter :
  sig
    type t
	type kind = Cobb | Saito | Ari
	
	val get_kind: t -> kind
	val get_loc: t -> Map.loc
	val get_limbo: t -> bool
	
	val set_loc: Map.loc -> t -> t	
	val set_limbo: bool -> t -> t
	val make: kind -> Map.loc -> t
  end

module Init_info :
  sig
    type t
    val ruletable : t -> Ruletable.t
    val supporters : t -> Supporter.t list
    val init_state : t -> Ruletable.state
    val final_states : t -> Ruletable.state list
    val make :
      Ruletable.t ->
      Supporter.t list -> Ruletable.state -> Ruletable.state list -> t
  end

module Info :
  sig
    type t
    val map : t -> Map.t
    val header_loc : t -> Map.loc
    val supporters : t -> Supporter.t list
    val turn : t -> int
    val state : t -> Ruletable.state
    val make :
      Map.t -> Map.loc -> Supporter.t list -> int -> Ruletable.state -> t
  end

module Judge :
  sig
    type direction = Left | Right
    type symbol = Map.symbol
    type action = Move of direction | Erase | Write of symbol | Stay
    type t = action list list
  end

module type CLIENT =
  sig
    type t
    val create : Init_info.t -> Info.t -> t
    val judge : Info.t -> t -> Judge.t * t
  end

module Inception :
  functor (Client : CLIENT) ->
    sig
      val run : Ruletable.t -> Ruletable.state -> Ruletable.state list -> Map.t -> Map.loc list -> Map.loc -> int -> unit
    end
