(* 
 * SNU 4190.310 Programming Languages (Fall 2006)
 *
 * K- Interpreter II
 *)   

{
open Parser
exception Eof

val keyword_table = Hashtbl.create 18
val _ =
  List.iter (fn (kwd, tok) => Hashtbl.add keyword_table kwd tok)
            [("call", CALL),
             ("do", DO),
             ("else", ELSE),
             ("end", END),
             ("false", FALSE),
             ("for", FOR),
             ("if", IF),
             ("in", IN),
             ("let", LET),
             ("malloc", MALLOC),
             ("not", NOT),
             ("procedure", PROC),
             ("read", READ),
             ("then", THEN),
             ("to", TO),
             ("true", TRUE),
             ("unit", UNIT),
             ("while", WHILE),
             ("write", WRITE)]

val level = ref 0
} 

rule token = parse
    "/*" { level := 0 ; comments lexbuf }
  | "\r\n" { token lexbuf }
  | [' ' '\t' '\n'] { token lexbuf }
  | ['0'-'9']+ { NUM (int_of_string (Lexing.lexeme lexbuf)) }
  | ['a'-'z' 'A'-'Z']['a'-'z' 'A'-'Z' '0'-'9' '_']*'\''* {
      let
        val id = Lexing.lexeme lexbuf
      in
        (Hashtbl.find keyword_table id) handle Not_found => ID id
      end
    }
  | "&" { AMPER }
  | ":=" { COLONEQ }
  | "," { COMMA }
  | "." { DOT }
  | "=" { EQUAL }
  | ">" { GREATER }
  | "{" { LBRACE }
  | "<" { LESS }
  | "(" { LPAREN }
  | "-" { MINUS }
  | "+" { PLUS }
  | "}" { RBRACE }
  | ")" { RPAREN }
  | ";" { SEMICOLON }
  | "/" { SLASH }
  | "*" { STAR }
  | eof { EOF }

and comments = parse
     "*/" {
       if !level = 0 then token lexbuf
       else (level := !level - 1 ; comments lexbuf)
     }
   | "/*" { level := !level + 1 ; comments lexbuf }
   | _  { comments lexbuf }
   | eof { raise Eof }
