(*
 * SNU 4190.310 Programming Languages (Fall 2006)
 *
 * K- Interpreter I
 *)

fun main () =
    let
      val ptree = ref false
      val src = ref ""

      val _ =
        Arg.parse
          [("-ptree", Arg.Set ptree, "display parse tree")]
          (fn x => src := x)
          ("Usage: " ^ (Filename.basename Sys.argv.[0]) ^ " [-ptree] [file]")
    in
      let
        val lexbuf =
          Lexing.from_channel (if !src = "" then stdin else open_in !src)
        val pgm = Parser.program Lexer.token lexbuf
      in
        if !ptree then KParseTreePrinter.print pgm
        else ignore (K.run (K.emptyMemory, K.emptyEnv, pgm))
      end
    end

val _ = main ()
