/*
 * SNU 4190.310 Programming Languages (Fall 2006)
 *
 * K- Interpreter I
 */
  
%token <int> NUM
%token CALL DO ELSE END FALSE FOR IF IN LET MALLOC NOT PROC READ THEN TO TRUE
%token UNIT WHILE WRITE
%token <string> ID
%token AMPER COLONEQ COMMA DOT EQUAL GREATER LBRACE LESS LPAREN MINUS PLUS
%token RBRACE RPAREN SEMICOLON SLASH STAR

%token EOF

%token UMINUS DEREF

%left SEMICOLON
%nonassoc WRITE
%right COLONEQ
%left EQUAL
%left LESS
%left PLUS MINUS
%left STAR SLASH
%right NOT AMPER UMINUS DEREF
%left DOT

%start program
%type <K.program> program

%%

program:
    expr EOF { $1 }
  ;

expr: 
    LPAREN expr RPAREN { $2 }
  | NUM { K.NUM $1 }
  | MINUS NUM %prec UMINUS { K.NUM (-$2) }
  | TRUE { K.TRUE }
  | FALSE { K.FALSE }
  | UNIT { K.UNIT }
  | ID { K.VAR $1 }
  | CALL ID LPAREN expr RPAREN { K.CALLV ($2, $4) }
  | CALL ID LESS ID GREATER { K.CALLR ($2, $4) }
  | expr PLUS expr { K.ADD ($1, $3) }
  | expr MINUS expr  {K.SUB ($1, $3) }
  | expr STAR expr { K.MUL ($1, $3) }
  | expr SLASH expr { K.DIV ($1, $3) }
  | expr EQUAL expr { K.EQUAL ($1, $3) }
  | expr LESS expr { K.LESS ($1, $3) }
  | NOT expr { K.NOT $2 }
  | ID COLONEQ expr { K.ASSIGNV ($1, $3) }
  | expr SEMICOLON expr { K.SEQ ($1, $3) }
  | IF expr THEN expr ELSE expr END { K.IF2 ($2, $4, $6) }
  | IF expr THEN expr END { K.IF1 ($2, $4) }
  | WHILE expr DO expr END { K.WHILE ($2, $4) }
  | FOR ID COLONEQ expr TO expr DO expr END { K.FOR ($2, $4, $6, $8) }
  | READ ID { K.READ $2 }
  | WRITE expr { K.WRITE $2 }
  | LET ID COLONEQ expr IN expr END { K.LETV ($2, $4, $6) }
  | LET PROC ID LPAREN ID RPAREN EQUAL expr IN expr END {
      K.LETF ($3, $5, $8, $10)
    }
  | LBRACE fields RBRACE { K.RECORD $2 }
  | expr DOT ID COLONEQ expr { K.ASSIGNF ($1, $3, $5) }
  | expr DOT ID { K.FIELD ($1, $3) }
  | MALLOC LPAREN expr RPAREN { K.MALLOC $3 }
  | AMPER ID { K.AMPER $2 }
  | STAR expr %prec DEREF { K.STAR $2 }
  | expr COLONEQ expr { K.ASSIGNG ($1, $3) }
  ;

fields:
  | ID COLONEQ expr COMMA ID COLONEQ expr { [($1, $3), ($5, $7)] }      
%%
