
open Answer

let pprint exp =
     
    let rec pprint exp level = 
        match exp with
        | Zexpr.NUM n -> 
            if n < 0 then Printf.printf "(%d)" n
            else print_int n
        | Zexpr.PLUS (e1, e2) ->
        (
            print_string "(";
            pprint e1 level;
            print_string " + ";
            pprint e2 level;
            print_string ")";
        )   
        
        | Zexpr.MINUS (e1, e2) ->
        (         
            print_string "(";
            pprint e1 level;
            print_string " - ";
            pprint e2 level;
            print_string ")";
        )
        
        | Zexpr.MULT (e1, e2) ->
        (         
            print_string "(";
            pprint e1 level;
            print_string " * ";
            pprint e2 level;
            print_string ")";
        )
        
        | Zexpr.DIVIDE (e1, e2) ->
        (         
            print_string "(";
            pprint e1 level;
            print_string " / ";
            pprint e2 level;
            print_string ")";
        )
        
        | Zexpr.MAX elst ->
        (
            print_string "max [";
            
            let rec iter el = 
                match el with            
                | [hd] -> (pprint hd level; print_string "]")            
                | [] -> print_string "]"
                | hd::tl -> (pprint hd level; print_string "; "; iter tl) in
    
            iter elst;
        )
        
        | Zexpr.VAR id -> print_string id
    
        | Zexpr.LET (id, e1, e2) -> 
        (         
            Printf.printf "let %s = " id;
            pprint e1 (level + 1);
            print_endline " in";
            for i = 1 to level - 1 do print_string "    " done;
            pprint e2 level;
        )
    in    
    pprint exp 1

let pprint_ocaml exp =

    let print_level level = 
        for i = 1 to level do print_string " " done in
     
    let rec pprint exp level = 
        match exp with
        | Zexpr.NUM n -> 
            if n < 0 then
                Printf.printf "NUM (%d)" n
            else
                Printf.printf "NUM %d" n
        | Zexpr.PLUS (e1, e2) ->
        (
            print_string "PLUS (";
            pprint e1 (level + 6);
            print_endline ", ";
            print_level (level + 6);
            pprint e2 (level + 6);
            print_string ")";
        )   
        
        | Zexpr.MINUS (e1, e2) ->
        (
            print_string "MINUS (";
            pprint e1 (level + 7);
            print_endline ", ";
            print_level (level + 7);
            pprint e2 (level + 7);
            print_string ")";

        )
        
        | Zexpr.MULT (e1, e2) ->
        (         
            print_string "MULT (";
            pprint e1 (level + 6);
            print_endline ", ";
            print_level (level + 6);
            pprint e2 (level + 6);
            print_string ")";
        )
        
        | Zexpr.DIVIDE (e1, e2) ->
        (         
            print_string "DIVIDE (";
            pprint e1 (level + 8);
            print_endline ", ";
            print_level (level + 8);
            pprint e2 (level + 8);
            print_string ")";
        )
        
        | Zexpr.MAX elst ->
        (
            let level = level + 5 in
            print_string "MAX [";
            
            let rec iter el = 
                match el with
                | [hd] -> (
                    pprint hd level; print_string "]"
                )

                | [] -> print_string "]"

                | hd::tl -> (pprint hd level; print_endline "; "; print_level level; iter tl) in
    
            iter elst;
        )
        
        | Zexpr.VAR id -> Printf.printf "VAR \"%s\"" id
    
        | Zexpr.LET (id, e1, e2) -> 
        (
            let level = level + 5 in
            Printf.printf "LET (\"%s\", \n" id;
            print_level level;
            pprint e1 level;
            print_endline ", ";
            print_level level;
            pprint e2 level;
            print_string ")";
        )
    in    
    pprint exp 0

let _ = 
    let cin = if Array.length Sys.argv > 1 then open_in Sys.argv.(1) else stdin in
    let lexbuf = Lexing.from_channel cin in
    let zexpr = ZexprParser.parse ZexprLexer.token lexbuf in

    (* Ľ   ֱ *)
    pprint zexpr;
    print_newline ();
    print_newline ();

    (* ocaml   ִ  ֱ *)
    pprint_ocaml zexpr;
    print_newline ();
    print_newline ();

    try
        ignore (Zexpr.eval (Zexpr.emptyEnv, zexpr))
    with
        Zexpr.Error msg -> print_string ("Error: " ^ msg)
